// import tools to write JUnit tests
import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.*;

public class MyCandyTests {
    private CandyBowl b; // global CandyBowl variable to be used by all tests
    
    @BeforeEach // will run before running every test
    public void createNew() {
        b = new CandyBowl("Milky Way"); // creates a new candy bowl every time
    }

    @Test // will run the following method as a test
    public void testCheckCandyCount() {
        // checks the two values are equal
        assertEquals(b.checkCandyCount(),10); 
    }
    
    @Test
    public void testGetCandyName() {
        assertEquals(b.getCandyName(),"Milky Way"); // checks name of b
        // creates a second candy bowl to test
        CandyBowl b2 = new CandyBowl("Butterfinger"); 
        // you can have multiple assert statements in one test
        assertEquals(b2.getCandyName(),"Butterfinger"); 
    }
    
    @Test
    public void testTake5Refill7() {
        b.takeCandy(5);
        b.refillCandy(7);
        assertEquals(b.checkCandyCount(), 12);
    } 

}
