#include <unistd.h>
#include <stdbool.h>
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>

void handler(int signo) {
  if(signo == SIGALRM){
    printf("There was an alarm! Can you believe it?\n");
  }
  kill(0, SIGKILL);
}


int main() {
  struct sigaction sa = {
    .sa_handler = handler
  };
  sigaction(SIGALRM, &sa, NULL);
  
  alarm(2);

  while(true);

  return EXIT_SUCCESS;
}

