#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

bool done = false;

void my_awesome_handler(int signo) {
  if (signo == SIGALRM) {
    printf("alarm delivered\n");
    done = true;
  }
  if (signo == SIGINT) {
    printf("got sigint\n");
  }
}

int main(int argc, char *argv[]){

    sigset_t mask;
    sigset_t old_mask;
    // initialize the set
    if (sigemptyset(&mask) == -1) {
        perror("sigemptyset failed, idk how but it did.\n");
        exit(EXIT_FAILURE);
    }

    // add SIGINT to the set
    if(sigaddset(&mask, SIGINT) == -1) {
        perror("sigaddset failed, idk how but it did.\n");
        exit(EXIT_FAILURE);
    }

    // block SIGINT
    if (sigprocmask(SIG_BLOCK, &mask, &old_mask) == -1) {
        perror("sigprocmask failed, idk how but it did.\n");
        exit(EXIT_FAILURE);
    }
    
    struct sigaction sa;

    sa.sa_handler = my_awesome_handler;
    sa.sa_flags = SA_RESTART;  // No special flags necessary.
    sigemptyset(&sa.sa_mask);  // Do not block additional signals during handler execution
    //we need this so that the trash in sa, isn't used to set the signal mask.

    sigaction(SIGALRM, &sa, NULL);
    sigaction(SIGINT, &sa, NULL);
    
    alarm(5);

    while (!done) { }

    // after alarm, unblock sigint
    if (sigprocmask(SIG_SETMASK, &old_mask, NULL) == -1) { 
        perror("sigprocmask failed, idk how but it did");
        exit(EXIT_FAILURE);
    }
    
    sa.sa_handler = SIG_DFL;
    sigaction(SIGINT, &sa, NULL);
    // infinitely loop, SIGINT should now be able
    // to terminate us and should be automatically received.
    while (true) { } 

    return EXIT_SUCCESS;

}
