#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>


int main(int argc, char *argv[]){
    int sleeps = 0;
    int signal_sent = 0;
    int status = -1;
    
    if(argc != 2){
        printf("Usage error: ./impatient <time_for_child_to_sleep>\n");
        return EXIT_FAILURE;
    }

    pid_t child_pid = fork();

    if(child_pid == 0){ /* Child Only. */   
        sleep(atoi(argv[1]));
        return EXIT_SUCCESS;
    }

    int res_pid = waitpid(child_pid, &status, WNOHANG); // is going to block until the child is dead

    while(!WIFEXITED(status) && !WIFSIGNALED(status)){

        if(sleeps < 5) {
            printf("Child has not yet excited. Sleeping for a second; will check after I wake up...\n");
            sleep(1);
            sleeps += 1;

        } else if(!signal_sent){
            printf("It's over for you. You're done.\n");
            kill(child_pid, SIGKILL);
            signal_sent = 1;
        }
        
        int res_pid = waitpid(child_pid, &status, WNOHANG);
    }
    printf("I have reaped my child.\nGoodbye.\n");
    return EXIT_SUCCESS;
}
















