#include <signal.h>
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

static bool done = false;

void handler(int signo) {
    if (signo == SIGALRM) {
        while (!done) {
            printf("I'm loooooping.....\n");
        }
        printf("I guess I am done... \n");
    }

    if (signo == SIGINT) {
        printf("Got SIGINT!\n");
        done = true;
    }
}

int main() {
    struct sigaction sa = (struct sigaction){
        .sa_handler = handler,
            .sa_flags = SA_RESTART
    };

    if (sigaction(SIGALRM, &sa, NULL) == -1) {  
        perror("Can't handle SIGALRM");
        exit(EXIT_FAILURE);
    }

    if (sigaction(SIGINT, &sa, NULL) == -1) {
        perror("Can't handle SIGINT");
        exit(EXIT_FAILURE);
    }

    alarm(1);

    while (!done) {
        printf("I'm in the while!\n");
    }
    
    printf("About to exit normally!\n");
    return EXIT_SUCCESS;
}
