#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>

int main(){
    pid_t child_pid = fork();

    if(child_pid < 0){
        perror("Fork failed.\n");
        return EXIT_FAILURE;
    }
    if(child_pid == 0){
        char *argv[] = {"sleep", "10", NULL};
        execvp(argv[0], argv); /* Similar to execve, without ENVP. */
        return EXIT_FAILURE; /* Should not be reachable */
    } else {
        int status;
        pid_t res = waitpid(-1, &status, WNOHANG);
        while(res == 0){ /* No updates. */
            printf("Waiting for child...\n");
            res = waitpid(-1, &status, WNOHANG);
        }
        printf("Done waiting for child!");
    }
    return EXIT_SUCCESS;
}

