
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>



int main(){

    sigset_t set;
    sigemptyset(&set);

    sigprocmask(0, NULL, &set); 

    printf("Received the following mask: %x.\n", set);
    
    sigemptyset(&set);
    sigaddset(&set, SIGINT);
    
    sigset_t previous_set;
    sigemptyset(&previous_set);

    sigprocmask(SIG_BLOCK, &set, &previous_set);

    printf("Received the following mask using empty set: %x.\n", previous_set);
    printf("Should now be the following: %x.\n", set);

    sigemptyset(&previous_set);
    sigprocmask(0, NULL, &previous_set);
    printf("Current mask is the following: %x.\n", set);


}