#include <signal.h>
#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

int main(){
    sigset_t mask;
    sigset_t old_mask;

    if (sigemptyset(&mask) == -1){
        perror("sigemptyset failed, idk how but it did");
        exit(EXIT_FAILURE);
    }

    if (sigaddset(&mask, SIGINT) == -1){
        perror("sigaddset failed, idk how but it did");
        exit(EXIT_FAILURE);
    }
    
    sigaddset(&mask, SIGALRM);

    sigprocmask(SIG_BLOCK, &mask, &old_mask);
    
    alarm(5);
        
    int signal_rec = -1;
    while(signal_rec != SIGALRM){
        sigwait(&mask, &signal_rec);
        printf("Received a signal!\n");
    }
    
    sigsuspend(&old_mask);
    printf("Was the disposition triggered for SIGINT or not?\n");
    return EXIT_SUCCESS;
}
