#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
    pid_t cpid = fork();

    if (cpid == 0)
    { /* Code executed by child */
        pid_t mypid = getpid();
        printf("Child PID is %d\n", mypid);

        sleep(10);

        printf("Kid: Ahh, I'm about to die!\n");
        exit(EXIT_SUCCESS); // defined as 0
    }

    int status;

    printf("Waiting for child to terminate...\n");
    pid_t child_changed = waitpid(cpid, &status, 0);

    if (WIFEXITED(status))
    { /* Should always enter here... */
        printf("Child has exited and has been reaped!\n");
    }

    return EXIT_SUCCESS;

}
