#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>

int main(int argc, char *argv[])
{


    pid_t cpid = fork();

    if (cpid == 0){ /* Code executed by child */

        pid_t mypid = getpid();

        printf("Child PID is %d\n", mypid);
        sleep(3);
        
        kill(mypid, SIGSTOP); // I will stop myself, hopefully the parents continues me!

        sleep(3);

        exit(EXIT_SUCCESS); //defined as 0
    }
    
    int status;

    pid_t child_changed = waitpid(cpid, &status, WUNTRACED | WCONTINUED | WNOHANG);

    while(!WIFEXITED(status)){
        
        if(WIFSTOPPED(status)){
            printf("Child has been stopped\n");
            printf("Let's get it to contiue again!\n");
            kill(cpid, SIGCONT);
        }
        if(WIFCONTINUED(status)){
            printf("Child has been continued!\n");
        }

        child_changed = waitpid(cpid, &status, WUNTRACED | WCONTINUED);
    }

    printf("Child has exited and has been reaped!\n");

    return EXIT_SUCCESS;
   
}
