#include <signal.h>
#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

bool done = false;

void handler(int signo){
    if (signo == SIGALRM){
        printf("alarm delivered\n");
    }
}

int main(){
    sigset_t mask;
    sigset_t old_mask;

    if (sigemptyset(&mask) == -1){
        perror("sigemptyset failed, idk how but it did");
        exit(EXIT_FAILURE);
    }

    if (sigaddset(&mask, SIGINT) == -1){
        perror("sigaddset failed, idk how but it did");
        exit(EXIT_FAILURE);
    }

    struct sigaction sa = {
        .sa_handler = handler
    };

    struct sigaction sigint_sa = {
        .sa_handler = SIG_IGN
    };

    struct sigaction sigint_old = {0};
    sigaction(SIGALRM, &sa, NULL);
    
    sigaction(SIGINT, &sigint_sa, &sigint_old);
    
    alarm(5);

    sigsuspend(&mask);
    
    sigaction(SIGINT, &sigint_old, NULL);
    sigsuspend(&old_mask);

    return EXIT_SUCCESS;
}
