#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdio.h>
#include <fcntl.h>

//don't ask me about this yet, we aren't using it in the demo
//linux stuff isn't portable to the Macintosh. 
//so if i'm not in the envrnmt, pipe2 doesn't exist
#define pipe2(FD, FLAG) \
    pipe((FD)); \
    fcntl((FD)[0], F_SETFD, FD_CLOEXEC); \
    fcntl((FD)[1], F_SETFD, FD_CLOEXEC)




#define WRITE_END 1
#define READ_END 0

void close_pipe(int *pipe){
    if(pipe == NULL) return;
    close(pipe[0]);
    close(pipe[1]);
}

// cat bee_movie.txt | grep Barry | uniq
// ok let's see if we can do this in one go.
void pipe_processes(char **cat_argv, char **grep_argv, char **uniq_argv){
    
    
    pid_t cat_pid = fork();
    if(cat_pid == 0){
        execvp(cat_argv[0], cat_argv);
        _exit(EXIT_FAILURE);
    }
    
    pid_t grep_pid = fork();
    if(grep_pid == 0){
        execvp(grep_argv[0], grep_argv);
        _exit(EXIT_FAILURE);
    }

    pid_t uniq_pid = fork();
    if(uniq_pid == 0){
        execvp(uniq_argv[0], uniq_argv);
        _exit(EXIT_FAILURE);
    }

}
int main(int argc, char *argv[]){

    char *cat_argv[] = {"cat", "bee_movie.txt", NULL};
    char *grep_argv[] = {"grep", "Barry", NULL};
    char *uniq_argv[] = {"uniq", NULL};

    pipe_processes(cat_argv, grep_argv, uniq_argv);

    return EXIT_SUCCESS;

}





