#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdio.h>
#include <fcntl.h>

//linux stuff isn't portable to the Macintosh. 
//so if i'm not in the envrnmt, pipe2 doesn't exist
#define pipe2(FD, FLAG) \
    pipe((FD)); \
    fcntl((FD)[0], F_SETFD, FD_CLOEXEC); \
    fcntl((FD)[1], F_SETFD, FD_CLOEXEC)


#define WRITE_END 1
#define READ_END 0

void close_pipe(int *pipe){
    if(pipe == NULL) return;
    close(pipe[0]);
    close(pipe[1]);
}

// cat bee_movie.txt | grep Barry | uniq
// ok let's see if we can do this in one go.
void pipe_processes(char **cat_argv, char **grep_argv, char **uniq_argv){
    
    int cat_pipe[2];
    
    pipe2(cat_pipe, O_CLOEXEC);
    
    pid_t cat_pid = fork();
    if(cat_pid == 0){
        dup2(cat_pipe[WRITE_END], STDOUT_FILENO);
        execvp(cat_argv[0], cat_argv);
        _exit(EXIT_FAILURE);
    }

    int grep_pipe[2];
    pipe2(grep_pipe, O_CLOEXEC);

    pid_t grep_pid = fork();

    if(grep_pid == 0){
        dup2(cat_pipe[READ_END], STDIN_FILENO);
        dup2(grep_pipe[WRITE_END], STDOUT_FILENO);
        execvp(grep_argv[0], grep_argv);
        _exit(EXIT_FAILURE);
    }

    pid_t uniq_pid = fork();
    if(uniq_pid == 0){
        dup2(grep_pipe[READ_END], STDIN_FILENO);
        execvp(uniq_argv[0], uniq_argv);
        _exit(EXIT_FAILURE);
    }
    close_pipe(grep_pipe);
    close_pipe(cat_pipe);
    int i = 3;
    while(i--){
        wait(NULL);
    }
}


int main(int argc, char *argv[]){

    char *cat_argv[] = {"cat", "bee_movie.txt", NULL};
    char *grep_argv[] = {"grep", "Barry", NULL};
    char *uniq_argv[] = {"uniq", NULL};

    pipe_processes(cat_argv, grep_argv, uniq_argv);

    return EXIT_SUCCESS;

}





