#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <stdbool.h>
#include <sys/wait.h>

#define BUF_SIZE 1024

int main() {
  pid_t pid = fork();

  if (pid == 0) {
    // child
    // reads from the terminal and 
    // prints what it reads until EOF
    char buf[BUF_SIZE + 1];

    ssize_t chars_read = read(STDIN_FILENO, buf, BUF_SIZE);

    while(chars_read > 0) {
      buf[chars_read] = '\0';
      printf("%s", buf);
      chars_read = read(STDIN_FILENO, buf, BUF_SIZE);
    } 

    exit(EXIT_SUCCESS);
  }

  // parent

  // put the child in its own process group
  if (setpgid(pid, pid) == -1) {
    perror("setpgid\n");
    exit(EXIT_FAILURE);
  }

  // give terminal to the child
  if(tcsetpgrp(STDIN_FILENO, pid) == -1) {
    perror("tcsetpgrp\n");
    exit(EXIT_FAILURE);
  }

  printf("starting to wait\n");

  int wstatus;
  waitpid(pid, &wstatus, 0);
  
  exit(EXIT_SUCCESS);

}
