/*  pgrp_signals.c 
 *  This file demonstrates why process groups are usefull 
 *  especially in the context of job management within a shell
 *  program. Here we install two seperate handlers, in the 
 *  child and the parent, where the parent forwards the signal
 *  to the child when appropriate.
 */


#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdbool.h>

static pid_t child_pid = 0;

#define NEWGROUP 0

void parent_handler(int signo) {
    if (signo == SIGINT) {
        printf("Parent I got SIGINT!\n");
        //printf("Forwarding Signal to %d\n", child_pid);
        //let's relay the signal.
        //kill(child_pid, SIGINT);
        exit(EXIT_SUCCESS);
    }
}

void child_handler(int signo) {
    if (signo == SIGINT) {
        printf("Child: I got SIGINT!\n");
        exit(EXIT_SUCCESS);
    }
}

int main() {

    child_pid = fork();
    
    if (child_pid == 0) {
        // child
        struct sigaction sigact_child = {
                .sa_flags = SA_RESTART,
                .sa_handler = child_handler
        };
        
        if (sigaction(SIGINT, &sigact_child, NULL) == -1) {
            perror("signal\n");
            exit(EXIT_FAILURE);
        }

        while(true);
        exit(EXIT_FAILURE);
    }

    // parent
    struct sigaction sigact_parent = {
        .sa_flags = SA_RESTART, 
        .sa_handler = parent_handler
    };    

    if (sigaction(SIGINT, &sigact_parent, NULL) == -1) {
        perror("signal\n");
        exit(EXIT_FAILURE);
    }
    #if NEWGROUP
    // code to put child in new group here! 
    setpgid(child_pid, child_pid);
    #endif
    // What is printed if we hit CTRL + C?

    // what if we put the process in a new group?
    while(true);
    exit(EXIT_FAILURE);
}
