#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <stdbool.h>
#include <sys/wait.h>

#define BUF_SIZE 1024


int main() {
  while (true) {
    fprintf(stderr, "give command: ");
    char c;
    ssize_t bytes  = read(STDIN_FILENO, &c, 1);
    if (bytes == -1) {
      perror("read\n");
      exit(EXIT_FAILURE);
    } else if (bytes == 0) {
      break;
    }

    if (c == 'c') {
      pid_t pid = fork();

      if (pid == 0) {
        // child
        // reads from the terminal and 
        // prints what it reads until EOF
        char* args[] = {"cat", NULL};
        execvp(args[0], args);
        exit(EXIT_FAILURE);
      }
      // parent

      // put the child in its own process group
      if (setpgid(pid, pid) == -1) {
        perror("setpgid\n");
        exit(EXIT_FAILURE);
      }

      // give terminal to the child
      if(tcsetpgrp(STDIN_FILENO, pid) == -1) {
        perror("tcsetpgrp\n");
        exit(EXIT_FAILURE);
      }
      printf("starting to wait\n");

      int wstatus;
      waitpid(pid, &wstatus, 0);
    } else if (c == 's') {
      printf("sleeping...\n");
      sleep(5);
      printf("awake\n");
    } else if (c == 'p') {
      printf("HOWDY\n");
    }
  }
  
  exit(EXIT_SUCCESS);

}
